#ifndef __CSlider__
#define __CSlider__

#include "CControl.hpp"
#include "CRolloverButton.hpp"
#include <MathTools/CBounds.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CControl;
using Exponent::GUI::Controls::CRolloverButton;
using Exponent::MathTools::CBounds;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CSlider CSlider.hpp
			 * @brief Represents a slider.
			 *
			 * @date 19/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CSlider.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CSlider : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CSlider(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CSlider();

//	===========================================================================

				/**
				 * Set the value of the slider
				 * @param value The value of the slider (0 - 1 range) 
				 */
				virtual void setValue(const double value);

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Set the slider images
				 * @param sliderHandle The image of the area that can be grabbed by the user
				 * @param sliderOver The image of the area that can be grabbed by the user when mouse is over
				 * @param sliderDown The image of the area that can be grabbed by the user when mouse is grabbing it
				 * @param sliderDisabled The image of the area that can be grabbed by the user when the control is disabled
				 */
				virtual void setSliderImages(IImage *sliderHandle, IImage *sliderOver, IImage *sliderDown, IImage *sliderDisabled);

				/**
				 * Set the colours
				 * @param frameColour The colour of the frame
				 * @param backgroundColour The background colour of the control
				 * @param handleColour The colour of the area that can be grabbed by the user
				 * @param handleOverColour The colour of the area that can be grabbed by the user when mouse is over
				 * @param handleDownColour The colour of the area that can be grabbed by the user when mouse is grabbing it
				 */
				virtual void setColours(CAlphaColour frameColour, CAlphaColour backgroundColour, CAlphaColour handleColour, CAlphaColour handleOverColour, CAlphaColour handleDownColour);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the scroll wheel
				 * @param event The event to handle
				 */
				virtual void handleMouseScroll(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Handle the mouse leaving the window area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * Check if the control is enabled. If it isnt, draw the disabled background and return
				 * @param graphics The graphics context
				 * @retval bool TRue if should draw, false if disabled / shouldnt draw
				 */
				virtual bool drawEnabledControl(CGraphics &graphics);

				/**
				 * Check if the area is rolled over and lock if it is
				 * @param point The point to check
				 */
				virtual void checkAndLock(const CPoint &point);

//	===========================================================================

				IImage *m_sliderHandleImage;				/**< The slider image */
				IImage *m_sliderOverImage;					/**< The over image */
				IImage *m_sliderDownImage;					/**< The down image */
				IImage *m_sliderDisabledImage;				/**< The disabled image */

				CRect m_sliderPosition;						/**< The position of the slider */
				CPoint m_grabOffset;						/**< What is the offset to where they grabbed? */

				CRolloverButton::ERolloverState m_state;	/**< Current state of slider (0 = off : 1 = over : 2 = on) */
				bool m_isVertical;							/**< Is the slider vertical? */
				bool m_isDragging;							/**< Are we dragging the slider */

				double m_sliderRange;						/**< The range of the slider */

				CAlphaColour m_handleColour;				/**< Colour of the slider */
				CAlphaColour m_handleOverColour;			/**< Colour of the slider when mouse is over */
				CAlphaColour m_handleDownColour;			/**< Colour of the slider when mouse is down */

			};
		}
	}
}
#endif	// End of CSlider.hpp